#include <bits/stdc++.h>
#include <bits/extc++.h>
#include <chrono>

using namespace std;
using namespace chrono;
using namespace __gnu_pbds;

template <class T>
using ordered_set = tree<T, null_type, less<T>, rb_tree_tag, tree_order_statistics_node_update>;

typedef long long ll;
typedef pair<ll, ll> pll;
typedef long double ld;

#define vc vector
#define all(v) v.begin(), v.end()
#define remin(a, b) a = min(a, b)
#define remax(a, b) a = max(a, b)

const ll inf = 1e15;
const ld eps = 1e-6;

void acceleration()
{
    cin.tie(0);
    cout.tie(0);
    ios_base::sync_with_stdio(0);
}

void solve();

void infile()
{
    freopen("C:\\work\\D\\d2.txt", "r", stdin);
}
void outfile()
{
    freopen("C:\\work\\D\\d2ans.txt", "w", stdout);
}

int main()
{
    acceleration();

    infile();
    outfile();

    ll t = 1;
    cin >> t;

    while (t--)
    {
        solve();
        cout << endl;
    }

    return 0;
}

ll dist(ll i, ll j, ll _i, ll _j)
{
    return abs(i - _i) + abs(j - _j);
}

ll dist(pll a, pll b)
{
    return dist(a.first, a.second, b.first, b.second);
}
ld getTime(std::chrono::_V2::steady_clock::time_point start)
{
    auto end = steady_clock::now();
    return duration<ld>(end - start).count();
}

struct solution1
{
    ll n, k, s;
    vc<vc<ll>> a;
    mt19937 rd;

    ll penalty(vc<ll> &x)
    {

        vc<pll> emppos(n + 1), joypos(k + 1);

        for (ll i = 0; i < s; ++i)
            for (ll j = 0; j < s; ++j)
            {
                ll idx = i * s + j;
                if (x[idx] < 0)
                {
                    joypos[-x[idx]] = {i, j};
                }
                else
                {
                    emppos[x[idx]] = {i, j};
                }
            }

        ll ans = 0;

        for (ll emp = 1; emp <= n; ++emp)
        {
            for (ll joy = 1; joy <= k; ++joy)
            {
                ans += a[emp][joy] * dist(emppos[emp], joypos[joy]);
            }
        }

        return ans;
    }

    void solve()
    {
        rd = mt19937(high_resolution_clock::now().time_since_epoch().count());
        cin >> n >> k >> s;

        a = vc<vc<ll>>(n + 1, vc<ll>(k + 1)); // a[employee][joy] = важность

        for (ll emp = 1; emp <= n; ++emp)
            for (ll joy = 1; joy <= k; ++joy)
                cin >> a[emp][joy];

        ll curpenalty = inf;
        vc<ll> best;
        vc<ll> x{};

        for (ll i = 1; i <= k; ++i)
            x.push_back(-i);
        for (ll i = 1; i <= n; ++i)
            x.push_back(i);

        vc<ll> perm(s * s);
        iota(all(perm), 0);

        do
        {
            vc<ll> curx(s * s);
            for (ll i = 0; i < curx.size(); ++i)
                curx[i] = x[perm[i]];

            ll _curpenalty = penalty(curx);

            if (_curpenalty < curpenalty)
            {
                curpenalty = _curpenalty;
                best = curx;
            }
        } while (next_permutation(all(perm)));

        // vc<ll> x_ = {6, -2, 1, -1, 4, -3, 2, 3, 5};
        // ll bestpenalty = penalty(x_);
        // cout << bestpenalty << " " << curpenalty;

        for (ll i = 0; i < s; ++i)
            for (ll j = 0; j < s; ++j)
            {
                cout << best[s * i + j] << " \n"[j == s - 1];
            }
    }
};

struct solution
{
    ll n, k, s;
    vc<vc<ll>> a;
    mt19937 rd;

    ll penalty(vc<ll> &x)
    {

        vc<pll> emppos(n + 1), joypos(k + 1);

        for (ll i = 0; i < s; ++i)
            for (ll j = 0; j < s; ++j)
            {
                ll idx = i * s + j;
                if (x[idx] < 0)
                {
                    joypos[-x[idx]] = {i, j};
                }
                else
                {
                    emppos[x[idx]] = {i, j};
                }
            }

        ll ans = 0;

        for (ll emp = 1; emp <= n; ++emp)
        {
            for (ll joy = 1; joy <= k; ++joy)
            {
                ans += a[emp][joy] * dist(emppos[emp], joypos[joy]);
            }
        }

        return ans;
    }
    bool go(ld chance)
    {
        return uniform_real_distribution<ld>(0, 1)(rd) < chance;
    }
    pair<ll, vc<ll>> anneal(ld mxtime)
    {
        ld temp = 1;

        ll bestpenalty = inf, curpenalty = inf;
        vc<ll> x{};
        vc<ll> best{};

        for (ll i = 1; i <= k; ++i)
            x.push_back(-i);
        for (ll i = 1; i <= n; ++i)
            x.push_back(i);

        shuffle(all(x), rd);
        best = x;

        curpenalty = bestpenalty = penalty(x);

        auto start = steady_clock::now();

        ll iter = 0;
        for (; (iter % 100 != 0) || getTime(start) < mxtime; ++iter)
        {
            temp *= 0.999;

            vc<ll> _x = x;
            ll i = uniform_int_distribution<ll>(0, _x.size() - 1)(rd);
            ll j = uniform_int_distribution<ll>(0, _x.size() - 1)(rd);
            swap(_x[i], _x[j]);

            ll _curpenalty = penalty(_x);

            if (_curpenalty < curpenalty || go(exp((bestpenalty - curpenalty) / temp)))
            {
                curpenalty = _curpenalty;
                x = _x;

                if (curpenalty < bestpenalty)
                {
                    bestpenalty = curpenalty;
                    best = x;
                }
            }
        }
        cerr << "iter" << " " << iter << endl;
        return {bestpenalty, best};
    }

    void solve()
    {
        rd = mt19937(high_resolution_clock::now().time_since_epoch().count());
        cin >> n >> k >> s;

        a = vc<vc<ll>>(n + 1, vc<ll>(k + 1)); // a[employee][joy] = важность

        for (ll emp = 1; emp <= n; ++emp)
            for (ll joy = 1; joy <= k; ++joy)
                cin >> a[emp][joy];

        pair<ll, vc<ll>> res = {inf, {}};




        ld runs = 2, mxtime = 3;
        for (ll i = 0; i < runs; ++i)
        {
            auto newRes = anneal(mxtime / runs);
            if (newRes.first < res.first)
                res = newRes;
        }

        cerr << res.first << endl
             << endl;

        for (ll i = 0; i < s; ++i)
            for (ll j = 0; j < s; ++j)
            {
                cout << res.second[s * i + j] << " \n"[j == s - 1];
            }
    }
};

void solve()
{
    solution s;
    s.solve();
}