#include <bits/stdc++.h>
#include <bits/extc++.h>

using namespace std;
using namespace __gnu_pbds;

typedef long long ll;
typedef pair<ll, ll> pll;
typedef long double ld;

#define vc vector
#define all(v) v.begin(), v.end()
#define remin(a, b) a = min(a, b)
#define remax(a, b) a = max(a, b)
#define endl "\n"

const ll inf = 1e15;
const ld eps = 1e-6;

const ll MOD = 998244353;

ll mult(ll a, ll b)
{
    return (a % MOD) * b % MOD;
}

ll sum(ll a, ll b)
{
    return (a + b) % MOD;
}

void acceleration()
{
    cin.tie(0);
    cout.tie(0);
    ios_base::sync_with_stdio(0);
}

void solve();

void infile()
{
    freopen("C:\\work\\B\\b2.txt", "r", stdin);
}
void outfile()
{
    freopen("C:\\work\\B\\b2ans.txt", "w", stdout);
}
vc<ll> fact;

int main()
{
    fact.assign(1e6, 0);
    fact[0] = 1;
    for (ll i = 1; i < fact.size(); ++i)
    {
        fact[i] = mult(fact[i - 1], i);
    }

    acceleration();

    infile();
    outfile();

    ll t = 1;
    cin >> t;

    while (t--)
    {
        solve();
        cout << endl;
    }

    return 0;
}

ll n;
vc<vc<ll>> g;
vc<bool> isLeaf;
vc<ll> h;

map<vc<ll>, ll> hasher;

void dfs(ll u, ll from)
{
    isLeaf[u] = true;

    vc<ll> cur = {};

    for (ll v : g[u])
    {
        if (v != from)
        {
            isLeaf[u] = false;
            dfs(v, u);

            cur.push_back(h[v]);
        }
    }

    if (hasher.find(cur) == hasher.end())
        h[u] = hasher[cur] = hasher.size();
    else
        h[u] = hasher[cur];
}

ll dfs1(ll u, ll from)
{
    ll ans = 1;
    map<ll, ll> cnt;

    for (ll v : g[u])
    {
        if (v != from)
        {
            cnt[h[v]]++;
            ans = mult(ans, dfs1(v, u));
        }
    }

    for (auto [curhash, curcnt] : cnt)
    {
        ans = mult(ans, fact[curcnt]);
    }

    return ans;
}

void solve()
{
    hasher.clear();
    hasher[vc<ll>{}] = 0;

    cin >> n;
    h.assign(n, -1);
    g.assign(n, {});
    isLeaf.assign(n, false);

    for (ll i = 0; i < n - 1; ++i)
    {
        ll u, v;
        cin >> u >> v;
        u--, v--;

        g[u].push_back(v);
        g[v].push_back(u);
    }

    dfs(0, -1);
    cout << dfs1(0, -1);
}